<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('ledg_grps', function (Blueprint $table) {
            $table->id('Gr_Id'); // Auto-incrementing primary key
            $table->bigInteger('Co_Id')->unsigned()->nullable(); // Foreign key
            $table->string('gr_code', 8)->nullable();
            $table->string('up_gr', 25)->nullable();
            $table->string('gr_nm', 75)->nullable();
            $table->decimal('gr_sr', 18, 0)->nullable();
            $table->string('gr_alt', 15)->nullable();
            $table->decimal('gr_stt', 9, 0)->nullable();
            $table->string('gr_al_c', 75)->nullable();
            $table->string('is_del', 1)->nullable();
            $table->string('gr_exp', 1)->nullable();
            $table->string('gr_buk', 1)->nullable();
            $table->string('gr_prt', 1)->nullable();
            $table->integer('op_id')->nullable();
            $table->string('dt_tm', 10)->nullable();
            $table->string('naof_grp', 10)->nullable();
            $table->string('credition', 50)->nullable();
            $table->string('eff_gp', 50)->nullable();
            $table->string('eff_sub_led', 50)->nullable();

            $table->foreign('Co_Id')->references('Co_Id')->on('co_masters')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ledg_grps');
    }
};
